/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.blockentity;

import com.mojang.authlib.GameProfile;
import java.security.SecureRandom;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.FakePlayer;
import novamachina.exnihilosequentia.common.block.BlockSieve;
import novamachina.exnihilosequentia.common.crafting.sieve.SieveRecipe;
import novamachina.exnihilosequentia.common.init.ExNihiloBlockEntities;
import novamachina.exnihilosequentia.common.item.MeshItem;
import novamachina.exnihilosequentia.common.item.mesh.MeshType;
import novamachina.exnihilosequentia.common.registries.ExNihiloRegistries;
import novamachina.exnihilosequentia.common.utility.Config;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class SieveEntity
extends BlockEntity {
    @Nonnull
    private static final String BLOCK_TAG = "block";
    @Nonnull
    private static final String MESH_TAG = "mesh";
    @Nonnull
    private static final String PROGRESS_TAG = "progress";
    @Nonnull
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());
    @Nonnull
    private final Random random = new SecureRandom();
    @Nonnull
    private ItemStack blockStack = ItemStack.f_41583_;
    private UUID lastPlayer;
    private long lastSieveAction = 0L;
    @Nonnull
    private ItemStack meshStack = ItemStack.f_41583_;
    @Nonnull
    private MeshType meshType = MeshType.NONE;
    private float progress = 0.0f;

    public SieveEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends SieveEntity>)((BlockEntityType)ExNihiloBlockEntities.SIEVE_ENTITY.get()), pos, state);
    }

    public SieveEntity(BlockEntityType<? extends SieveEntity> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public void activateSieve(@Nullable Player player, boolean isWaterlogged) {
        logger.debug("Activate Sieve, isWaterlogged: " + isWaterlogged);
        float fortune = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)this.meshStack);
        float efficiency = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44984_, (ItemStack)this.meshStack);
        if (this.f_58857_ != null && this.f_58857_.m_6106_().m_6793_() - this.lastSieveAction < 4L) {
            if (player != null && this.f_58857_.m_6106_().m_6793_() - this.lastSieveAction == 0L && this.lastPlayer.equals(player.m_142081_())) {
                MutableComponent message = new TextComponent("Autoclicker Bad").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)).m_131136_(Boolean.valueOf(true)));
                player.m_6352_((Component)message, Util.f_137441_);
            }
            return;
        }
        if (this.f_58857_ != null) {
            this.lastSieveAction = this.f_58857_.m_6106_().m_6793_();
        }
        if (player != null) {
            this.lastPlayer = player.m_142081_();
        }
        if (this.isReadyToSieve()) {
            this.progress += 1.0f * (1.0f + efficiency / 5.0f);
            if (this.progress >= (float)Config.getMaxSieveClicks()) {
                logger.debug("Sieve progress complete");
                List<SieveRecipe> drops = ExNihiloRegistries.SIEVE_REGISTRY.getDrops((ItemLike)((BlockItem)this.blockStack.m_41720_()).m_40614_(), this.meshType, isWaterlogged);
                drops.forEach(entry -> entry.getRolls().forEach(meshWithChance -> {
                    if (this.random.nextFloat() <= meshWithChance.getChance() * (1.0f + fortune / 3.0f)) {
                        logger.debug("Spawning Item: " + entry.getDrop());
                        this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 1.1f), (double)((float)this.f_58858_.m_123343_() + 0.5f), entry.getDrop()));
                    }
                }));
                this.resetSieve();
            }
        }
    }

    @Nonnull
    public ItemStack getBlockStack() {
        return this.blockStack;
    }

    @Nonnull
    public MeshType getMeshType() {
        return this.meshType;
    }

    public float getProgress() {
        return this.progress / (float)Config.getMaxSieveClicks();
    }

    @Nullable
    public ResourceLocation getTexture() {
        if (!this.blockStack.m_41619_()) {
            return this.blockStack.m_41720_().getRegistryName();
        }
        return null;
    }

    @Nonnull
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        if (!this.meshStack.m_41619_()) {
            CompoundTag meshNBT = this.meshStack.m_41739_(new CompoundTag());
            nbt.m_128365_(MESH_TAG, (Tag)meshNBT);
        }
        if (!this.blockStack.m_41619_()) {
            CompoundTag blockNbt = this.blockStack.m_41739_(new CompoundTag());
            nbt.m_128365_(BLOCK_TAG, (Tag)blockNbt);
        }
        nbt.m_128350_(PROGRESS_TAG, this.progress);
        return nbt;
    }

    public void insertMesh(@Nonnull ItemStack stack, @Nonnull Player player) {
        logger.debug("Insert Mesh: " + stack);
        MeshItem mesh = (MeshItem)stack.m_41720_();
        if (this.meshStack.m_41619_()) {
            this.meshStack = stack.m_41777_();
            this.meshStack.m_41764_(1);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.meshType = mesh.getType();
            if (!this.m_58901_()) {
                this.setSieveState();
            }
            this.m_6596_();
        }
    }

    public void insertSiftableBlock(@Nonnull ItemStack stack, @Nonnull Player player) {
        logger.debug("Insert Siftable Block: " + stack);
        if (!this.meshStack.m_41619_() && this.blockStack.m_41619_()) {
            this.blockStack = stack.m_41777_();
            this.blockStack.m_41764_(1);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
        }
    }

    public boolean isReadyToSieve() {
        return !this.meshStack.m_41619_() && !this.blockStack.m_41619_();
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        Tag blockTag;
        if (compound.m_128441_(MESH_TAG)) {
            Tag meshTag = compound.m_128423_(MESH_TAG);
            if (meshTag != null) {
                this.meshStack = ItemStack.m_41712_((CompoundTag)((CompoundTag)meshTag));
                if (this.meshStack.m_41720_() instanceof MeshItem) {
                    this.meshType = ((MeshItem)this.meshStack.m_41720_()).getType();
                }
            } else {
                this.meshStack = ItemStack.f_41583_;
            }
        } else {
            this.meshStack = ItemStack.f_41583_;
        }
        this.blockStack = compound.m_128441_(BLOCK_TAG) ? ((blockTag = compound.m_128423_(BLOCK_TAG)) != null ? ItemStack.m_41712_((CompoundTag)((CompoundTag)blockTag)) : ItemStack.f_41583_) : ItemStack.f_41583_;
        this.progress = compound.m_128457_(PROGRESS_TAG);
        super.m_142466_(compound);
    }

    public void onDataPacket(@Nonnull Connection net, @Nonnull ClientboundBlockEntityDataPacket packet) {
        Tag blockTag;
        CompoundTag nbt = packet.m_131708_();
        if (nbt.m_128441_(MESH_TAG)) {
            Tag meshTag = nbt.m_128423_(MESH_TAG);
            if (meshTag != null) {
                this.meshStack = ItemStack.m_41712_((CompoundTag)((CompoundTag)meshTag));
                if (this.meshStack.m_41720_() instanceof MeshItem) {
                    this.meshType = ((MeshItem)this.meshStack.m_41720_()).getType();
                }
            } else {
                this.meshStack = ItemStack.f_41583_;
            }
        } else {
            this.meshStack = ItemStack.f_41583_;
        }
        this.blockStack = nbt.m_128441_(BLOCK_TAG) ? ((blockTag = nbt.m_128423_(BLOCK_TAG)) != null ? ItemStack.m_41712_((CompoundTag)((CompoundTag)blockTag)) : ItemStack.f_41583_) : ItemStack.f_41583_;
        this.progress = nbt.m_128457_(PROGRESS_TAG);
    }

    public void removeMesh(boolean rerenderSieve) {
        logger.debug("Remove mesh: Rerender Sieve: " + rerenderSieve);
        if (!this.meshStack.m_41619_()) {
            if (this.f_58857_ != null) {
                this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 0.5f), (double)((float)this.f_58858_.m_123343_() + 0.5f), this.meshStack.m_41777_()));
            }
            this.meshStack = ItemStack.f_41583_;
            this.meshType = MeshType.NONE;
            if (rerenderSieve) {
                this.setSieveState();
            }
        }
    }

    private void resetSieve() {
        logger.debug("Resetting sieve");
        if (Config.enableMeshDurability()) {
            logger.debug("Damaging mesh");
            this.meshStack.m_41622_(1, (LivingEntity)new FakePlayer((ServerLevel)this.f_58857_, new GameProfile(UUID.randomUUID(), "Fake Player")), player -> logger.debug("Broken"));
        }
        this.blockStack = ItemStack.f_41583_;
        this.progress = 0.0f;
        if (this.meshStack.m_41619_()) {
            logger.debug("Setting mesh to none, potential broken mesh");
            this.meshType = MeshType.NONE;
            this.setSieveState();
        }
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        if (!this.meshStack.m_41619_()) {
            CompoundTag meshNBT = this.meshStack.m_41739_(new CompoundTag());
            compound.m_128365_(MESH_TAG, (Tag)meshNBT);
        }
        if (!this.blockStack.m_41619_()) {
            CompoundTag blockNBT = this.blockStack.m_41739_(new CompoundTag());
            compound.m_128365_(BLOCK_TAG, (Tag)blockNBT);
        }
        compound.m_128350_(PROGRESS_TAG, this.progress);
    }

    public void m_7651_() {
        super.m_7651_();
    }

    public void setSieveState() {
        logger.debug("Set Sieve State, Mesh: " + this.meshType);
        BlockState state = this.m_58900_();
        if (state.m_60734_() instanceof BlockSieve && this.f_58857_ != null) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)state.m_61124_(BlockSieve.MESH, (Comparable)((Object)this.meshType)));
        }
    }
}

